/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.beachparty.entity.chair;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import satisfyu.beachparty.entity.chair.ChairEntity;
import satisfyu.beachparty.registry.EntityRegistry;

public class ChairUtil {
    private static final Map<ResourceLocation, Map<BlockPos, Pair<ChairEntity, BlockPos>>> CHAIRS = new HashMap<ResourceLocation, Map<BlockPos, Pair<ChairEntity, BlockPos>>>();

    public static InteractionResult onUse(Level world, Player player, InteractionHand hand, BlockHitResult hit, double extraHeight) {
        if (world.f_46443_) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (ChairUtil.isPlayerSitting(player)) {
            return InteractionResult.PASS;
        }
        if (hit.m_82434_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        BlockPos hitPos = hit.m_82425_();
        if (!ChairUtil.isOccupied(world, hitPos) && player.m_21120_(hand).m_41619_()) {
            ChairEntity chair = (ChairEntity)((EntityType)EntityRegistry.CHAIR.get()).m_20615_(world);
            chair.m_7678_((double)hitPos.m_123341_() + 0.5, (double)hitPos.m_123342_() + 0.25 + extraHeight, (double)hitPos.m_123343_() + 0.5, 0.0f, 0.0f);
            if (ChairUtil.addChairEntity(world, hitPos, chair, player.m_20183_())) {
                world.m_7967_((Entity)chair);
                player.m_20329_((Entity)chair);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static void onStateReplaced(Level world, BlockPos pos) {
        ChairEntity entity;
        if (!world.f_46443_ && (entity = ChairUtil.getChairEntity(world, pos)) != null) {
            ChairUtil.removeChairEntity(world, pos);
            entity.m_20153_();
        }
    }

    public static boolean addChairEntity(Level world, BlockPos blockPos, ChairEntity entity, BlockPos playerPos) {
        if (!world.f_46443_) {
            ResourceLocation id = ChairUtil.getDimensionTypeId(world);
            if (!CHAIRS.containsKey(id)) {
                CHAIRS.put(id, new HashMap());
            }
            CHAIRS.get(id).put(blockPos, (Pair<ChairEntity, BlockPos>)Pair.of((Object)((Object)entity), (Object)playerPos));
            return true;
        }
        return false;
    }

    public static boolean removeChairEntity(Level world, BlockPos pos) {
        ResourceLocation id;
        if (!world.f_46443_ && CHAIRS.containsKey(id = ChairUtil.getDimensionTypeId(world))) {
            CHAIRS.get(id).remove(pos);
            return true;
        }
        return false;
    }

    public static ChairEntity getChairEntity(Level world, BlockPos pos) {
        ResourceLocation id;
        if (!world.f_46443_ && CHAIRS.containsKey(id = ChairUtil.getDimensionTypeId(world)) && CHAIRS.get(id).containsKey(pos)) {
            return (ChairEntity)((Object)CHAIRS.get(id).get(pos).getFirst());
        }
        return null;
    }

    public static BlockPos getPreviousPlayerPosition(Player player, ChairEntity chairEntity) {
        ResourceLocation id;
        if (!player.f_19853_.f_46443_ && CHAIRS.containsKey(id = ChairUtil.getDimensionTypeId(player.f_19853_))) {
            for (Pair<ChairEntity, BlockPos> pair : CHAIRS.get(id).values()) {
                if (pair.getFirst() != chairEntity) continue;
                return (BlockPos)pair.getSecond();
            }
        }
        return null;
    }

    public static boolean isOccupied(Level world, BlockPos pos) {
        ResourceLocation id = ChairUtil.getDimensionTypeId(world);
        return CHAIRS.containsKey(id) && CHAIRS.get(id).containsKey(pos);
    }

    public static boolean isPlayerSitting(Player player) {
        for (ResourceLocation i : CHAIRS.keySet()) {
            for (Pair<ChairEntity, BlockPos> pair : CHAIRS.get(i).values()) {
                if (!((ChairEntity)((Object)pair.getFirst())).m_20363_((Entity)player)) continue;
                return true;
            }
        }
        return false;
    }

    private static ResourceLocation getDimensionTypeId(Level world) {
        return world.m_220362_().m_135782_();
    }
}

